$(document).ready(async function () {

    $('#txtAliquota').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtAliquotaInterna').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtCombate').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtCodigo: {
                required: true,
            },
            txtDescricao: {
                required: true,
            },
            txtCoduf: {
                required: true,
            },
            txtPais: {
                required: true,
            }
        },
        messages: {
            txtCodigo: {
                required: "Informe uma UF válida.",
            },
            txtDescricao: {
                required: "Informe uma descrição válida."
            },
            txtCoduf: {
                required: "Informe um código válido."
            },
            txtPais: {
                required: "Informe um país válido."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    $("#btnGravar").click(function () {

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            gravarUf();
        }
    });

    $('#txtPais').autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
    $('#btnPais').pesquisa('#txtPais', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cadpais", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa País', 'cadpais');
    $('#btnAPais').on('click', function () {
        $('#txtPais').val('');
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let uf = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('PRODUTO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/uf`;
    });

    if (uf != '' && uf != 'create') {
        carregaDados();
    }

    async function carregaDados() {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ 
                        "tabela":"tabuf", 
                        "camposSelect":["codigo", "descricao", "coduf", "pais", "aliquota", "aliq_int", "perc_fundo_pobreza", "FCP_OP_INTERNA"], 
                        "where": ["codigo = '${uf}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                $('#txtCoduf').val(jsonStr.RESULT[0][0].CODUF);
                $('#txtAliquota').val(jsonStr.RESULT[0][0].ALIQUOTA);
                $('#txtAliquotaInterna').val(jsonStr.RESULT[0][0].ALIQ_INT);
                $('#txtCombate').val(jsonStr.RESULT[0][0].PERC_FUNDO_POBREZA);
                $('#cbGeraFcpOpInterna').prop('checked', jsonStr.RESULT[0][0].FCP_OP_INTERNA == 'S');

                try {
                    let responseOperadora = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"cadpais", 
                                "camposSelect":["nome"], 
                                "where": ["codigo = '${jsonStr.RESULT[0][0].PAIS}'"]}`, null);

                    let jsonStrOperadora = await responseOperadora.json();

                    insereValor('#txtPais', jsonStr.RESULT[0][0].PAIS, jsonStrOperadora.RESULT[0][0].NOME);

                } catch (error) {
                    console.error(error);
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function gravarUf() {
        try {
            $.LoadingOverlay("show");
            uf = {};

            uf.CODIGO = $('#txtCodigo').val().replace('-', '').toUpperCase();
            uf.DESCRICAO = $('#txtDescricao').val().toUpperCase();
            uf.CODUF = $('#txtCoduf').val();
            uf.PAIS = pegaChave('#txtPais', uf.PAIS);
            uf.ALIQUOTA = $('#txtAliquota').val();
            uf.ALIQ_INT = $('#txtAliquotaInterna').val();
            uf.PERC_FUNDO_POBREZA = $('#txtCombate').val();
            uf.EMP_ID = getCookie('emp_id');
            uf.FCP_OP_INTERNA = isChecked('#cbGeraFcpOpInterna') ? 'S' : 'N';

            let response = await requisicao('POST', '/Sisplan/Cadastros/v1/uf?', `JSON=${encodeURIComponent(JSON.stringify(uf))}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            };

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }
            $.LoadingOverlay("hide");
            toastr.success(
                'Cadastro efetuado com sucesso!',
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden() {
                    window.location.href = `${BASE_URI}/uf`;
                }
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro(`Não foi possível gravar os dados do CEP: ${error}`);
        }
    };
});

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#telatour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'UF',
                description: 'Neste campo adicionamos a UF abreviada.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para a UF.',
                position: 'top'
            }
        },
        {
            element: '#txtCoduf',
            popover: {
                title: 'Código UF',
                description: 'Aqui adicionamos o código da UF.',
                position: 'top'
            }
        },
        {
            element: '#txtPais',
            popover: {
                title: 'País',
                description: 'Selecionamos o país neste campo.',
                position: 'top'
            }
        },
        {
            element: '#btnVoltar',
            popover: {
                title: 'Botão Voltar',
                description: 'Ao clicar nesse botão você retorna para a tela de consulta.',
                position: 'left'
            }
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a UF.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});